/**********************************************************************
 *<
	FILE: RwParticle.cpp

	DESCRIPTION:	Appwizard generated plugin

	CREATED BY: 

	HISTORY: 

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/
#include "stdafx.h"
#include "..\resource.h"
#include "RwParticle.h"

/*************************************************************************
 Local (static) Globals
*/

static RwParticleClassDesc      _rwGParticleClassDesc;
static RwEmitterCreateCallback  _rwGParticleCreate;
ClassDesc2* GetRwParticleDesc() {return &_rwGParticleClassDesc;}

/*************************************************************************
 Local Defines
*/

/*===========================================================================*\
 |	Texture Param Block Accessor
\*===========================================================================*/

class RwParticlePBAccessor : public PBAccessor
{
public:

    void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
    {
        RwParticle *rwParticle = (RwParticle *)owner;
        switch (id)
        {
           case plPARTICLECOUNT:
            {
				rwParticle->parts.FreeAll();
				rwParticle->parts.SetCount(v.i, PARTICLE_VELS | PARTICLE_AGES);
            }
            break;
			// We need to invalidate the UI manually since there is no animation on the parametes
			case plEMITTERWIDTH:
			case plEMITTERHEIGHT:
            {
				rwParticle->mvalid.SetEmpty();
            }
            break;
        }
    }
};

static RwParticlePBAccessor    _aGParamAccess;

static ParamBlockDesc2 pbdSpawnParamDesc( rwPARTICLESPAWNPARAM, _T("spawnparams"),  0, &_rwGParticleClassDesc, 
	P_AUTO_CONSTRUCT + P_AUTO_UI, SPAWN_ROLLOUT_REF, 
	//rollout
	IDD_SPAWNING, IDS_SPAWNPARAMS, 0, APPENDROLL_CLOSED, NULL,
	//params
	plEMITTERWIDTH,		_T("width"),		TYPE_WORLD, 		0, 	IDS_SPIN, 	
		p_default, 		0.1f, 
		p_range, 		0.0f,1000.0f, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_UNIVERSE,  IDC_EMITTER_WIDTH,	IDC_EMITTER_WIDTHSPIN, SPIN_AUTOSCALE, 
		p_accessor,     &_aGParamAccess,
		end,
	plEMITTERHEIGHT,	_T("height"),		TYPE_WORLD, 		0, 	IDS_SPIN, 	
		p_default, 		0.1f, 
		p_range, 		0.0f,1000.0f, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_UNIVERSE,  IDC_EMITTER_HEIGHT,	IDC_EMITTER_HEIGHTSPIN, SPIN_AUTOSCALE, 
		p_accessor,     &_aGParamAccess,
		end,
	plPARTICLECOUNT,	_T("count"),		TYPE_INT, 			0, 	IDS_SPIN, 	
		p_default, 		100, 
		p_range, 		1,16384, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_INT,	IDC_NUM_PARTICLES,	IDC_NUM_PARTICLESSPIN, SPIN_AUTOSCALE, 
		p_accessor,     &_aGParamAccess,
		end,
	plPARTICLEMINSPEED,	_T("minspeed"),		TYPE_FLOAT, 		0, 	IDS_SPIN, 	
		p_default, 		20.0f, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_FLOAT, IDC_PARTICLE_MINSPEED,	IDC_PARTICLE_MINSPEEDSPIN, SPIN_AUTOSCALE, 
		end,
	plPARTICLEMAXSPEED, _T("maxspeed"),	    TYPE_FLOAT, 		0, 	IDS_SPIN, 	
		p_default, 		0.0f, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_FLOAT, IDC_PARTICLE_MAXSPEED,	IDC_PARTICLE_MAXSPEEDSPIN, SPIN_AUTOSCALE, 
		end,
	plPARTICLELIFETIME,	_T("life"),			TYPE_TIMEVALUE,		0,	IDS_SPIN, 	
		p_default, 		TIME_TICKSPERSEC, 
		p_range,		0,	TIME_TICKSPERSEC * 20,
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_INT,		IDC_PARTICLE_LIFE,	IDC_PARTICLE_LIFESPIN, SPIN_AUTOSCALE, 
		p_accessor,     &_aGParamAccess,
		end,
    plEMITTERHIDE,		_T("hide"),			TYPE_BOOL,			0,	IDS_SPIN,
		p_default,		FALSE,
		p_ui,			TYPE_SINGLECHEKBOX, IDC_HIDE_EMITTER,
		end,
	plPARTICLEANGLE,	_T("angle"),		TYPE_ANGLE,			0, 	IDS_SPIN, 	
		p_default, 		0.0f, 
		p_range,		0.0f, 90.0f,
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_FLOAT,	IDC_PARTICLE_ANGLE,	IDC_PARTICLE_ANGLESPIN, SPIN_AUTOSCALE, 
		end,
    plPARTICLEDAMPING,	_T("damping"),		TYPE_FLOAT,			0,	IDS_SPIN,
		p_default, 		0.0f, 
		p_range,		0.0f, 1.0f,
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_FLOAT,	IDC_PARTICLE_DAMPING, IDC_PARTICLE_DAMPINGSPIN, SPIN_AUTOSCALE, 
		end,
    plRANDOMSEED,		_T("seed"),			TYPE_INT,			0,	IDS_SPIN,
		p_default, 		0, 
		p_range,		0, 8388608,
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_INT,	IDC_RANDOM_SEED,	IDC_RANDOM_SEEDSPIN, SPIN_AUTOSCALE, 
		end,
    plFORCEX,           _T("force x"),      TYPE_FLOAT,         0,  IDS_SPIN,
		p_default, 		0.0f, 
		p_range,		-100.0f, 100.0f,
		p_ui,           TYPE_SPINNER,       EDITTYPE_FLOAT,     IDC_FORCEX,    IDC_FORCESPINX,    SPIN_AUTOSCALE, 
		end,
    plFORCEY,           _T("force y"),      TYPE_FLOAT,         0,  IDS_SPIN,
		p_default, 		0.0f, 
		p_range,		-100.0f, 100.0f,
		p_ui,           TYPE_SPINNER,       EDITTYPE_FLOAT,     IDC_FORCEY,    IDC_FORCESPINY,    SPIN_AUTOSCALE, 
		end,
    plFORCEZ,           _T("force z"),      TYPE_FLOAT,         0,  IDS_SPIN,
		p_default, 		-9.81f, 
		p_range,		-100.0f, 100.0f,
		p_ui,           TYPE_SPINNER,       EDITTYPE_FLOAT,     IDC_FORCEZ,    IDC_FORCESPINZ,    SPIN_AUTOSCALE, 
		end,
	end
);

/*===========================================================================*\
 |	Texture Param Block Accessor
\*===========================================================================*/

class RwParticleRenderPBAccessor : public PBAccessor
{
public:

    void Set(PB2Value& v, ReferenceMaker* owner, ParamID id, int tabIndex, TimeValue t)
    {
        RwParticle *rwParticle = (RwParticle *)owner;
        switch (id)
        {
			case plCOLOURSTARTCOL:
			{
			}
			break;
        }
    }
};

static RwParticleRenderPBAccessor    _aGRenderAccess;

static ParamBlockDesc2 pbdRenderParamDesc( rwPARTICLERENDERPARAM, _T("renderparams"),  0, &_rwGParticleClassDesc, 
	P_AUTO_CONSTRUCT + P_AUTO_UI, RENDER_ROLLOUT_REF, 
	//rollout
	IDD_APPEARANCE, IDS_RENDERPARAMS, 0, APPENDROLL_CLOSED, NULL,
	//params
	plPARTICLESIZE,		_T("size"),			TYPE_WORLD, 		0, 	IDS_SPIN, 	
		p_default, 		0.5f, 
		p_ui, 			TYPE_SPINNER,		EDITTYPE_POS_UNIVERSE, IDC_PARTICLE_SIZE,	IDC_PARTICLE_SIZESPIN, SPIN_AUTOSCALE, 
		end,
	plRENDERGROWTH,     _T("growth"),      TYPE_FLOAT,         0,  IDS_SPIN,
		p_default, 		1.0f, 
		p_range,		-1000.0f, 1000.0f,
		p_ui,           TYPE_SPINNER,       EDITTYPE_FLOAT,     IDC_RENDER_GROWTH,    IDC_RENDER_GROWTHSPIN,    SPIN_AUTOSCALE, 
		end,
    plRENDERASPECTRATIO,_T("aspect"),      TYPE_FLOAT,         0,  IDS_SPIN,
		p_default, 		1.0f, 
		p_range,		-1000.0f, 1000.0f,
		p_ui,           TYPE_SPINNER,       EDITTYPE_FLOAT,     IDC_RENDER_ASPECTRATIO,    IDC_RENDER_ASPECTRATIOSPIN,    SPIN_AUTOSCALE, 
		end,
	plCOLOURSTARTCOL,	_T("startcolour"),	TYPE_RGBA,			0,  IDS_SPIN,
		p_default, 		Point3(1.0f, 1.0f, 1.0f), 
		p_ui, 			TYPE_COLORSWATCH,	IDC_COLOUR_SWATCH,
		end,
	plCOLOURSTARTALPHA, _T("startalpha"),	TYPE_PCNT_FRAC,	0,  IDS_SPIN,
		p_default,		2.55f,
		p_range,		0.0f,255.0f,
		p_ui,			TYPE_SLIDER,		EDITTYPE_POS_INT, IDC_ALPHA_EDIT1,	IDC_ALPHA_SLIDER1, 2, 
		end,
	plCOLOURENDCOL,		_T("endcolour"),	TYPE_RGBA,			0,  IDS_SPIN,
		p_default, 		Point3(1.0f, 1.0f, 1.0f), 
		p_ui, 			TYPE_COLORSWATCH,	IDC_COLOUR_SWATCH3,
		end,
	plCOLOURENDALPHA,	_T("endalpha"),		TYPE_PCNT_FRAC,	0,  IDS_SPIN,
		p_default,		2.55f,
		p_range,		0.0f,255.0f,
		p_ui,			TYPE_SLIDER,		EDITTYPE_POS_INT, IDC_ALPHA_EDIT3,	IDC_ALPHA_SLIDER3, 2, 
		end,

	end
);

/*===========================================================================*\
 |	Update Particles
 |	This is the business end of proceedings
\*===========================================================================*/

void RwParticle::UpdateParticles(TimeValue t, INode *node)
{
	Point3		vGravity(0.0f, 0.0f, 0.0f);
    float       fForceX = 0.0f, fForceY = 0.0f, fForceZ = 0.0f;
	int			nIndex;
	TimeValue	tLifeTime;
	float		fMinSpeed;
	float		fMaxSpeed;
	float		width, height;
	float		angle, fDamping;
    int			nRandom;

	pbSpawnRollout->GetValue(plPARTICLELIFETIME,  t, tLifeTime,		FOREVER);
	pbSpawnRollout->GetValue(plPARTICLEMINSPEED,  t, fMinSpeed,	    FOREVER);
	pbSpawnRollout->GetValue(plPARTICLEMAXSPEED,  t, fMaxSpeed,     FOREVER);
	pbSpawnRollout->GetValue(plEMITTERWIDTH,	  t, width,			FOREVER);
	pbSpawnRollout->GetValue(plEMITTERHEIGHT,	  t, height,		FOREVER);
	pbSpawnRollout->GetValue(plPARTICLEANGLE,	  t, angle,			FOREVER);
	pbSpawnRollout->GetValue(plPARTICLEDAMPING,	  t, fDamping,		FOREVER);
	pbRenderRollout->GetValue(plPARTICLESIZE,     t, parts.size,	FOREVER);
    pbSpawnRollout->GetValue(plRANDOMSEED,		  t, nRandom,       FOREVER);
	pbSpawnRollout->GetValue(plFORCEX,            t, fForceX,       FOREVER);
    pbSpawnRollout->GetValue(plFORCEY,            t, fForceY,       FOREVER);
    pbSpawnRollout->GetValue(plFORCEZ,            t, fForceZ,       FOREVER);

    vGravity.x = fForceX;
    vGravity.y = fForceY;
    vGravity.z = fForceZ;

	angle = angle/(PI*0.5f);

    // Reseed the generator
    rRandGen.RandomSeed(nRandom);

	for (nIndex=0; nIndex<parts.Count(); nIndex++)
	{
		Point3	vPos;
		Point3	vStartPos; 
		Point3	vStartVel;
		Matrix3	mEmitter = node->GetObjTMBeforeWSM(t);
		float	fPartSpeed;
		float	fPartAge;
		float	fAngleRangeX, fAngleRangeY;
		float	fRandX = rRandGen.Random(1);
		float	fRandY = rRandGen.Random(1);

		// Work out start pos
		vStartPos.x = (width  * fRandX) - (width / 2.0f);
		vStartPos.y = (height * fRandY) - (height / 2.0f);
		vStartPos.z = 0;

		vStartPos = vStartPos * mEmitter;

		// From now on we just want the rotation of the matrix
		mEmitter.NoTrans();		

		// Get initial velocity 
		fAngleRangeX = ((fRandX * 2.0f) - 1.0f);
		fAngleRangeY = ((fRandY * 2.0f) - 1.0f);

		vStartVel.x = angle * fAngleRangeX;
		vStartVel.y = angle * fAngleRangeY;
		vStartVel.z = 1.0f - ((vStartVel.x * vStartVel.x) + (vStartVel.y * vStartVel.y));	

        fPartSpeed=fMinSpeed+(fMaxSpeed-fMinSpeed)*rRandGen.Random(1);

		vStartVel = vStartVel * mEmitter * fPartSpeed;

		// Calculate the age of the last particle, ensures we always get the same number of random numbers and cost is constant
		fPartAge =  TicksToSec(t) - ( (TicksToSec(tLifeTime) * rRandGen.Random(1))); 
		if (fPartAge > TicksToSec(tLifeTime))
		{
			fPartAge = fmod(fPartAge, TicksToSec(tLifeTime));
		}

		// Do we want to display this particle
		if ((fPartAge > TicksToSec(tLifeTime)) || (fPartAge < 0) )
		{
			SetParticleAge(t, nIndex, -1);
		}
		else
		{
			// s = ut * 0.5at2 
			vPos = (vStartVel * fPartAge) + (0.5f * vGravity * fPartAge * fPartAge);

			vPos += vStartPos;

			SetParticlePosition(t, nIndex, vPos);
			SetParticleAge(t, nIndex, SecToTicks(fPartAge));
		}
	}
}

/*===========================================================================*\
 |	EmitterVisible
 |	Do we want to see this?
\*===========================================================================*/
BOOL RwParticle::EmitterVisible()
{
	int hide;
	pbSpawnRollout->GetValue(plEMITTERHIDE,	0,	hide,	FOREVER);
	return !hide;
}

/*===========================================================================*\
 |	Open and Close dialog UIs
 |	We ask the ClassDesc2 to handle Beginning and Ending EditParams for us
\*===========================================================================*/
void RwParticle::BeginEditParams(IObjParam *ip, ULONG flags, Animatable *prev)
{
	SimpleParticle::BeginEditParams(ip,flags,prev);
	_rwGParticleClassDesc.BeginEditParams(ip, this, flags, prev);

}
		
void RwParticle::EndEditParams( IObjParam *ip, ULONG flags,Animatable *next )
{
	SimpleParticle::EndEditParams(ip,flags,next);
	_rwGParticleClassDesc.EndEditParams(ip, this, flags, next);
}

/*===========================================================================*\
 |	Constructor
 |  Ask the ClassDesc2 to make the AUTO_CONSTRUCT paramblocks and wire them in
\*===========================================================================*/

RwParticle::RwParticle(void)
{
    int nParticleCount;

    pbSpawnRollout = NULL;
	pbRenderRollout = NULL;
    _rwGParticleClassDesc.MakeAutoParamBlocks(this);

	pbSpawnRollout->GetValue(plPARTICLECOUNT, 0, nParticleCount, FOREVER);
	parts.SetCount(nParticleCount, PARTICLE_VELS | PARTICLE_AGES);
	parts.SetCustomDraw(NULL);
}

/*===========================================================================*\
 |	GetValidity
 |  Particles only valid for an instant
\*===========================================================================*/
Interval RwParticle::GetValidity(TimeValue t)
{
	return Interval(t,t);
}

/*===========================================================================*\
 |	Build Emitter
 |  Generate the displayed geometry for the emitter object
\*===========================================================================*/
void RwParticle::BuildEmitter(TimeValue t, Mesh& amesh)
{
	float width, height;
	mvalid = FOREVER;
	pbSpawnRollout->GetValue(plEMITTERWIDTH, t, width, mvalid);
	pbSpawnRollout->GetValue(plEMITTERHEIGHT, t, height, mvalid);
	width  *= 0.5f;
	height *= 0.5f;

	mesh.setNumVerts(7);
	mesh.setNumFaces(6);
	mesh.setVert(0, Point3(-width,-height, 0.0f));
	mesh.setVert(1, Point3( width,-height, 0.0f));
	mesh.setVert(2, Point3( width, height, 0.0f));
	mesh.setVert(3, Point3(-width, height, 0.0f));
	mesh.setVert(4, Point3(  0.0f,   0.0f, 0.0f));
	mesh.setVert(5, Point3(  0.0f,   0.0f, (width+height)/2.0f));
	mesh.setVert(6, Point3(  0.0f,   0.0f, 0.0f));

	mesh.faces[0].setEdgeVisFlags(1,0,1);
	mesh.faces[0].setSmGroup(1);
	mesh.faces[0].setVerts(0,1,3);

	mesh.faces[1].setEdgeVisFlags(1,1,0);
	mesh.faces[1].setSmGroup(1);
	mesh.faces[1].setVerts(1,2,3);

	mesh.faces[2].setEdgeVisFlags(1,1,0);
	mesh.faces[2].setSmGroup(1);
	mesh.faces[2].setVerts(4,5,6);

	mesh.faces[3].setEdgeVisFlags(1,0,1);
	mesh.faces[3].setSmGroup(1);
	mesh.faces[3].setVerts(0,3,1);

	mesh.faces[4].setEdgeVisFlags(0,1,1);
	mesh.faces[4].setSmGroup(1);
	mesh.faces[4].setVerts(1,3,2);

	mesh.faces[5].setEdgeVisFlags(1,0,0);
	mesh.faces[5].setSmGroup(1);
	mesh.faces[5].setVerts(5,4,6);

	mesh.InvalidateGeomCache();
}

/*===========================================================================*\
 |	Get the size of our particle system
\*===========================================================================*/
void RwParticle::GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box)
{
	UpdateMesh(t);
	SimpleParticle::GetWorldBoundBox(t,inode,vpt,box);
}

/*===========================================================================*\
 |	Invalidate our UI (or the recently changed parameter)
\*===========================================================================*/
void RwParticle::InvalidateUI()
{
	pbdSpawnParamDesc.InvalidateUI(pbSpawnRollout->LastNotifyParamID());
	pbdRenderParamDesc.InvalidateUI(pbRenderRollout->LastNotifyParamID());
}

/*===========================================================================*\
 |	Clone the system
\*===========================================================================*/

RefTargetHandle RwParticle::Clone(RemapDir& remap) 
{
    RwParticle *newob = new RwParticle();	
    newob->ReplaceReference(SPAWN_ROLLOUT_REF,	pbSpawnRollout->Clone(remap));
	newob->ReplaceReference(RENDER_ROLLOUT_REF, pbRenderRollout->Clone(remap));
    newob->mvalid.SetEmpty();	
    newob->tvalid = FALSE;
    return newob;
}

CreateMouseCallBack* RwParticle::GetCreateMouseCallBack()
{
    _rwGParticleCreate.pRwParticles = this;
    return &_rwGParticleCreate;
}

ParamDimension *RwParticle::GetParameterDim(int pbIndex) 
{
	switch (pbIndex) 
	{
		case plEMITTERWIDTH:
		case plEMITTERHEIGHT:
		{
			return stdWorldDim;
		}
		break;

        case plPARTICLELIFETIME:		
		{
			return stdTimeDim;
		}
		break;
		
		default: 
		{
			return defaultDim;
		}
	}
}

/*===========================================================================*\
 |	Subanim & References support
\*===========================================================================*/

IParamBlock2*   
RwParticle::GetParamBlock(int i)        
{
	switch (i)
	{
		case SPAWN_ROLLOUT_REF:
		{
			return pbSpawnRollout;
		}
		break;
		case RENDER_ROLLOUT_REF:
		{
			return pbRenderRollout;
		}
		break;
		default:
		{
			return NULL;
		}
		break;
	}
}

IParamBlock2*   
RwParticle::GetParamBlockByID(BlockID id) 
{
	if (pbSpawnRollout->ID()==id)
	{
		return pbSpawnRollout;
	}
	else
	if (pbRenderRollout->ID()==id)
	{
		return pbRenderRollout;
	}
	return NULL;
} 


RefTargetHandle RwParticle::GetReference(int i) 
{
    switch (i)
    {
        case SPAWN_ROLLOUT_REF:
        {
            return (RefTargetHandle) pbSpawnRollout;
        }
        break;
        case RENDER_ROLLOUT_REF:
        {
            return (RefTargetHandle) pbRenderRollout;
        }
        break;
    }
    return NULL;
}

void RwParticle::SetReference(int i, RefTargetHandle rtarg) 
{
    switch (i)
    {
        case SPAWN_ROLLOUT_REF:
        {
            pbSpawnRollout = (IParamBlock2*)rtarg;  /* Not yet used */
        }
        break;
        case RENDER_ROLLOUT_REF:
        {
            pbRenderRollout = (IParamBlock2*)rtarg;  /* Not yet used */
        }
        break;
    }
}

RefResult 
RwParticle::NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message ) 
{
	switch (message) 
    {
		case REFMSG_CHANGE:
        {
			if (hTarget == pbSpawnRollout)
			{
				ParamID changing_param = pbSpawnRollout->LastNotifyParamID();
				pbdSpawnParamDesc.InvalidateUI(changing_param);
            }
			else
			if (hTarget == pbRenderRollout)
			{
				ParamID changing_param = pbSpawnRollout->LastNotifyParamID();
				pbdRenderParamDesc.InvalidateUI(changing_param);
            }
        }
		break;
	}
	return(REF_SUCCEED);
}


/*===========================================================================*\
 |	Interactive creation callback
\*===========================================================================*/

int 
RwEmitterCreateCallback::proc(ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat)
{
	if (msg == MOUSE_FREEMOVE)
	{
        vpt->SnapPreview(m, m, NULL, SNAP_IN_3D);
	}

	if (msg==MOUSE_POINT || msg==MOUSE_MOVE) 
    {
		switch(point)  
        {
			case 0:
            {
				sp0 = m;
				p0 = vpt->SnapPoint(m,m,NULL,SNAP_IN_3D);
				mat.SetTrans(p0);
				pRwParticles->pbSpawnRollout->SetValue(plEMITTERWIDTH,0,0.01f);
				pRwParticles->pbSpawnRollout->SetValue(plEMITTERHEIGHT,0,0.01f);
            }
		    break;

			case 1: 
            {
				mat.IdentityMatrix();
				sp1 = m;
				p1 = vpt->SnapPoint(m,m,NULL,SNAP_IN_3D);
				Point3 center = (p0+p1)/float(2);
				mat.SetTrans(center);
				pRwParticles->pbSpawnRollout->SetValue(plEMITTERWIDTH,0, (float)fabs(p1.x-p0.x));
				pRwParticles->pbSpawnRollout->SetValue(plEMITTERHEIGHT,0, (float)fabs(p1.y-p0.y));

				if (msg==MOUSE_POINT) 
                {
					if (Length(m-sp0)<3 || Length(p1-p0)<0.1f) 
                    {						
						return CREATE_ABORT;
					} 
                    else 
                    {
						return CREATE_STOP;
					}
				}			
            }
            break;
        }
	} 
    else 
    {
		if (msg == MOUSE_ABORT)
        {
			return CREATE_ABORT;
        }
	}
	return 1;
}

/*===========================================================================*\
 |	Render Function
\*===========================================================================*/

int RwParticle::CountLiveParticles()
{
	int c=0;
	for (int i=0; i<parts.Count(); i++) 
	{
		if (parts.Alive(i)) c++;
	}
	return c;
}

float RwParticle::GetParticleSize(TimeValue t, int nParticle)
{
	float		fSize, fGrowth;
	TimeValue	tLifeTime;
	float		fParticleTime;
    float       fScalePercentage;

	//Get the current particle size
	pbRenderRollout->GetValue(plPARTICLESIZE,		t, fSize,		FOREVER);
	pbRenderRollout->GetValue(plRENDERGROWTH,	    t, fGrowth,	    FOREVER);
	pbSpawnRollout->GetValue(plPARTICLELIFETIME,	t, tLifeTime,	FOREVER);

	//How long after the start of scaling time are we
	fParticleTime = TicksToSec(parts.ages[nParticle]);
	
	fScalePercentage	= fParticleTime / TicksToSec(tLifeTime);
	//growth is FinalSize/InitialSize
    fSize = ((fGrowth*fSize)-fSize)*fScalePercentage+fSize;

	return fSize;
}

Point3 RwParticle::GetParticleColour(TimeValue t, int nParticle)
{
/* NOTE : This function returns the correct colour for the age of the particle
          but the colour is not displayed correctly. This is because max
          would require a special material which needs to be setup from the
          colours controls on the particle system rollout. The colour displayed
          when the particle system is rendered in max comes from the material
          assigned to the emitter.
*/
    TimeValue	tLifeTime;
	Point3		cColourStart;
	Point3		cColourEnd;
	float		fParticleAge = TicksToSec(parts.ages[nParticle]);

	pbSpawnRollout->GetValue(plPARTICLELIFETIME,	t, tLifeTime,			FOREVER);

    // Fade start to end
    pbRenderRollout->GetValue(plCOLOURSTARTCOL, t, cColourStart,	FOREVER);
    pbRenderRollout->GetValue(plCOLOURENDCOL,	t, cColourEnd,		FOREVER);

	cColourStart += ((cColourEnd - cColourStart) * fParticleAge/TicksToSec(tLifeTime));

    return cColourStart;
}

Mesh* RwParticle::GetRenderMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete)
{
	int ix=0, nx=0, count;
	Matrix3 tm = Inverse(inode->GetObjTMAfterWSM(t));
	Matrix3 cam = Inverse(view.worldToView);
	Point3 v, v0, v1, camV = cam.GetRow(3);
	Mesh *pm = new Mesh;
    float fAspectRatio;

    pbRenderRollout->GetValue(plRENDERASPECTRATIO,  t, fAspectRatio,FOREVER);

	Update(t,inode);
	count = CountLiveParticles();

	pm->setNumFaces(count*2);
	pm->setNumVerts(count*4);
	pm->setNumVertCol(count*4);
	pm->setNumTVerts(count*4);
	pm->setNumTVFaces(count*2);

	for (int i=0; i<parts.Count(); i++) 
	{
		float	fParticleSize;
		Point3	cParticleColour;

		if (!parts.Alive(i)) 
		{
			continue;
		}

		// Compute this particle's size
		fParticleSize	= GetParticleSize(t, i);
		cParticleColour = GetParticleColour(t, i);

		// Compute a vector from the particle to the camera
		v  = Normalize(camV-parts[i]);		
		v0 = Normalize(Point3(0,0,1)^v)*(fParticleSize/2)*fAspectRatio;
		v1 = Normalize(v0^v)*fParticleSize/2;
		
		pm->verts[ix  ] = (parts[i]+v0+v1) * tm;
		pm->verts[ix+1] = (parts[i]-v0+v1) * tm;
		pm->verts[ix+2] = (parts[i]-v0-v1) * tm;
		pm->verts[ix+3] = (parts[i]+v0-v1) * tm;

		pm->faces[nx  ].setSmGroup(1);		
		pm->faces[nx  ].setVerts(ix+1,ix ,ix+2);
		pm->faces[nx  ].setMatID((MtlID)i);
		pm->faces[nx  ].setEdgeVisFlags(1,1,1);
		pm->faces[nx+1].setSmGroup(1);		
		pm->faces[nx+1].setVerts(ix+3,ix+2,ix  );
		pm->faces[nx+1].setMatID((MtlID)i);
	 	pm->faces[nx+1].setEdgeVisFlags(1,1,1);

		pm->setTVert(ix  ,1.0f,1.0f,0.0f);
		pm->setTVert(ix+1,0.0f,1.0f,0.0f);
		pm->setTVert(ix+2,0.0f,0.0f,0.0f);
		pm->setTVert(ix+3,1.0f,0.0f,0.0f);

		pm->tvFace[nx  ].setTVerts(ix+1,ix  ,ix+2);
		pm->tvFace[nx+1].setTVerts(ix+3,ix+2,ix  );

		pm->vertCol[ix  ] = cParticleColour;
		pm->vertCol[ix+1] = cParticleColour;
		pm->vertCol[ix+2] = cParticleColour;
		pm->vertCol[ix+3] = cParticleColour;
		
		ix += 4;
		nx += 2;
	}

	mesh.InvalidateGeomCache();
	needDelete = TRUE;
	return pm;
}
